﻿
CREATE PROCEDURE App.NVCC_usp_UpdateProductionLog

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Brian Diggs
--Object/SP Name        : App.NVCC_usp_UpdateProductionLog
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : App
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 2017-07-21
--
--Last Changed          : 2017-08-01
--Last Changed By		: Brian Diggs
--Reason For Change		: Explicit check that AccessDateTime is not null
--                        and UserID and HostName (to eliminate possible
--                        NULL predicates)
--
--Purpose               : Procedure to be run periodically to update the table
--                        NVCC_ProductionLog from the table NVCC_AccessLog
--                        based on the criteria of what is considered to be a
--                        package created in the production environment
--
--                        NVCC_ProductionLog is a non-normalized set of data
--                        (since it can be defined based on the contents of
--                        NVCC_AccessLog) that is indexed/optimized for reporting
--==================================================================================

BEGIN
	DECLARE @LastID int;
	SELECT @LastID = MAX(AccessLogID) FROM App.NVCC_ProductionLog

	INSERT INTO App.NVCC_ProductionLog
	SELECT
		al.AccessLogID,
		al.UserID,
		al.AccessDateTime,
		al.PatientSID,
		p.PatientICN,
		p.Sta3n
	FROM
		App.NVCC_AccessLog al
		INNER JOIN CDWWork.Patient.Patient p
			ON al.PatientSID = p.PatientSID
	WHERE
		al.UserID NOT IN ('VHA20\DNS   DUCKAJ', 'VHA20\USER', 'VHA20\USER', 'VHA20\DNS   KOHLEG', 'VHA20\USER') 
		AND al.UserID IS NOT NULL
		AND (
			al.HostName = 'SERVER.URL       ' OR
			--dev.nwic was being used to host users who could not covert to the VIA version during these dates
 			(al.HostName = 'SERVER.URL       ' AND AccessDateTime BETWEEN '2016-10-19' AND '2016-11-15')
			OR al.HostName = 'vaww.refdoc.DNS   ' --the EWIS hosted national production site
		)
		AND al.HostName IS NOT NULL
		AND AccessDateTime IS NOT NULL
		AND al.Action = 'PDF'
		AND ((AccessLogID > @LastID) OR (@LastID IS NULL))
END
